#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

struct vektor {
    int x, y, index;
    float ugao;
};

float ugao(int x, int y) {
    float temp=atan2(y, x)*180.0/M_PI;
    if (temp<0) temp+=360;
    return temp;
}

bool sortiranje(vektor a, vektor b) {
    return a.ugao<b.ugao;
}

int main() {
    int n;
    scanf("%d", &n);
    std::vector<vektor> arr(n);
    int r=0, best_l=0, best_r=0;
    long long best_dist=-1;
    long long curr_x=0, curr_y=0;
    for (int i=0; i<n; i++) {
        int x, y;
        scanf("%d %d", &x, &y);
        arr[i]={x,y,i,ugao(x, y)};
    }
    std::sort(arr.begin(), arr.end(), sortiranje);
    for (int i = 0; i < n; i++) arr.push_back({arr[i].x,arr[i].y,arr[i].index,arr[i].ugao+360});

    for (int l=0; l<n; l++) {
        curr_x=0;
        curr_y=0;
        r=l;

        while (r<l+n && arr[r].ugao-arr[l].ugao<180) {
            curr_x += arr[r].x;
            curr_y += arr[r].y;
            r++;
        }

        long long dist=curr_x*curr_x+curr_y*curr_y;
        if (dist>best_dist) {
            best_dist=dist;
            best_l=l;
            best_r=r;
        }
    }

    printf("%d\n", best_r-best_l);
    for (int i=best_l; i<best_r; i++) printf("%d ", arr[i].index+1);

    return 0;
}